#==============================================================================#
#==                    Ministerio de Educación del Ecuador                   ==#  
#==                  Subsecretaría de Fundamentos Educativos                 ==#
#==              Dirección Nacional de Investigación Educativa               ==#
#==============================================================================#

#==============================================================================#
#==    Elaborado por: Jhony Zabala                                           ==#
#==    Revisado: Rocio Soria                                                 ==#
#==    Aprobado por: Galo López                                              ==#
#==                                                                          ==#
#==    Fecha elaboración; 02/08/2022                                         ==#
#==============================================================================#

#==============================================================================#
#==    Indicaciones generales                                                ==#
#==                                                                          ==#
#==    1. Para poder instalar las librerías primero debe descargarse los     ==#
#==       paquetes, ejemplo;                                                 ==#
#==                         install.packages("tidyverse")                    ==#
#==   2.   setwd("Ingrese la ruta de la carpeta donde vas a trabajar ")      ==#
#==                                                                          ==#
#==                                                                          ==#
#==   3. Para abrir el archivo csv, debe copiar y pegar la ruta donde se    ==#
#==       encuentra guardado el archivo, además debe cambiar "\" por "/"     ==#
#==                                                                          ==#
#==   4. Al exportar las tablas creadas mediante el comando "saveWorkbook"   ==#
#==      copie y pegue la ruta donde desea guardar el archivo                ==#
#==                                                                          ==#
#==============================================================================#




setwd("")## establecer su directorio o carpeta de trabajo
library(readr)
library(tidyverse)
library(openxlsx)
adt <- read.csv(" ", sep=";")#ingresar entre las comillas la ruta donde se encuentra el archivo


#==================================================#
#========== PORCENTAJE POR PROVINCIAS==============#
#==================================================#

prov <- adt %>% group_by(p3) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- prov %>% 
  select_if(is.numeric) %>% 
  colSums()

prov <- bind_rows(prov, Total)


tprov <- write.xlsx(prov,".xlsx")
saveWorkbook(tprov,file = "/1.provincias.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo


#====================================================#
#======================= EDAD =======================#
#==  Nota: existe 220 casos perdidos               ==#
#====================================================#

gedad <- adt %>% mutate(gedad=case_when(p4<20~"Menor a 20 años",
                                        p4>=20 & p4<=40~"20-40 años",
                                        p4>=41 & p4<=60~"41-60 años",
                                        p4>=61~"Mas de 60 años"))

edad <- gedad %>% filter(!is.na(gedad)) %>% 
group_by(gedad) %>% 
  summarise(Total=n()) %>% 
  mutate(Porcentaje = round(Total/sum(Total)*100,2)) %>% 
  arrange(desc(Porcentaje))

Total <- edad %>% 
  select_if(is.numeric) %>% 
  colSums()

edad <- bind_rows(edad, Total)

tedad <- write.xlsx(edad,".xlsx")
saveWorkbook(tedad,file = "/4.edad.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo


#====================================================#
#================ ROL ENCUESTADO ====================#
#====================================================#


cargo <- adt %>% group_by(p5) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- cargo %>% 
  select_if(is.numeric) %>% 
  colSums()

cargo <- bind_rows(cargo, Total)


tcargo <- write.xlsx(cargo,".xlsx")
saveWorkbook(tcargo,file = "/2.cargo.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo


#====================================================#
#===================== AUTOIDENTIFICACIÓN ===========#
#====================================================#

adt <- adt %>% mutate(et=case_when(p6=="Mestizo"~"Mestizo",
                                   p6=="Montubio"~"Montubio",
                                   p6=="Indígena"~"Indígena",
                                   p6=="Blanco"~"Blanco",
                                   p6=="Afrodescendiente"~"Afrodescendiente",
                                   p6=="Mulato"~"Afrodescendiente",
                                   p6=="Negro"~"Afrodescendiente",
                                   p6=="Otro (especificar)"~"Otro"))


iden <- adt %>% group_by(et) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- iden %>% 
  select_if(is.numeric) %>% 
  colSums()

iden <- bind_rows(iden, Total)

tiden <- write.xlsx(iden,".xlsx")
saveWorkbook(tiden,file = "/5.identificacion.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo


#====================================================#
#==================== GÉNERO ========================#
#====================================================#


gen <- adt %>% group_by(p7) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))

total <- gen %>% 
  select_if(is.numeric) %>% 
  colSums()

gen <- bind_rows(gen,Total)

tgen <- write.xlsx(gen,".xlsx")
saveWorkbook(tgen,file = "/6.genero.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

#====================================================#
#============= NACIONALIDAD =========================#
#====================================================#


nac <- adt %>% group_by(p8) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))


Total <- nac %>% 
  select_if(is.numeric) %>% 
  colSums()

nac <- bind_rows(nac,Total)

tnac <- write.xlsx(nac,".xlsx")
saveWorkbook(tnac,file = "/7.nacionalidad.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

#====================================================#
#================ DISCAPACIDAD ======================#
#====================================================#


dis <- adt %>% group_by(p9) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- dis %>% 
  select_if(is.numeric) %>% 
  colSums()

dis <- bind_rows(dis, Total)

tdis <- write.xlsx(dis,".xlsx")
saveWorkbook(tdis,file = "/8.discapacidad.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

#====================================================#
#===================== ÁREA =========================#
#====================================================#

area <- adt %>% group_by(p10) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- area %>% 
  select_if(is.numeric) %>% 
  colSums()
area <- bind_rows(area,Total)

tarea <- write.xlsx(area,".xlsx")
saveWorkbook(tarea,file = "/9.area.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

#====================================================#
#============= CAMPO O CIUDAD =======================#
#====================================================#


campo <- adt %>% group_by(p11) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- campo %>% 
  select_if(is.numeric) %>% 
  colSums()
campo <- bind_rows(campo,Total)

tcampo <- write.xlsx(campo,".xlsx")
saveWorkbook(tcampo,file = "/10.campo.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

#==========================================================================#
#=========================== CONSULTAS ENCUESTA  ==========================#
#==========================================================================#

## p12 ¿Cuál cree usted que es el mayor reto para el planeta en el futuro?

reto <- adt %>% group_by(p12) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- reto %>% 
  select_if(is.numeric) %>% 
  colSums()
reto <- bind_rows(reto,Total)


treto <- write.xlsx(reto,".xlsx")
saveWorkbook(treto,file = "/11.reto.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

## p13	"¿Cuál debería ser la finalidad de la educación en el futuro?

finali <- adt %>% group_by(p13) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- finali %>% 
  select_if(is.numeric) %>% 
  colSums()
finali <- bind_rows(finali,Total)


tfinali <- write.xlsx(finali,".xlsx")
saveWorkbook(tfinali,file = "/12.finalidad.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

## p14	¿Cuál es el cambio que debería introducirse al Sistema Educativo del Ecuador en los próximos 10 años? 


cedu <- adt %>% group_by(p14) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- cedu %>% 
  select_if(is.numeric) %>% 
  colSums()

cedu <- bind_rows(cedu,Total)


tcedu <- write.xlsx(cedu,".xlsx")
saveWorkbook(tcedu,file = "/13.cambio_edu.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

## p15	Â¿Qué medida debería implementarse para garantizar la permanencia y la culminaciónn de los estudios de toda la población? 

med <- adt %>% group_by(p15) %>% 
  summarise(Total=n())%>%
    mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
    arrange(desc(Porcentaje))

Total <- med %>% 
  select_if(is.numeric) %>% 
  colSums()

med <- bind_rows(med,Total)

tmed <- write.xlsx(med,".xlsx")
saveWorkbook(tmed,file = "/14.medida.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo


##p16	Â¿Qué medida debería implementarse para mejorar el aprendizaje de los estudiantes? 

meda <- adt %>% group_by(p16) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- meda %>% 
  select_if(is.numeric) %>% 
  colSums()

meda <- bind_rows(meda,Total)

tmeda <- write.xlsx(meda,".xlsx")
saveWorkbook(tmeda,file = "/15.medida_apren.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

##p17	En su Opinión: ¿Cuál es la principal forma de lograr que las familias y la 
##comunidad participen más activamente en el proceso educativo de las niñas, niñoos y jóvenes? 


par <- adt %>% group_by(p17) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- par %>% 
  select_if(is.numeric) %>% 
  colSums()

par <- bind_rows(par,Total)



tpar <- write.xlsx(par,".xlsx")
saveWorkbook(tpar,file = "/16.participacion.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo


## p18	¿Cómo cree usted que evolucionará la educación luego de la pandemia del COVID 19?



evo <- adt %>% group_by(p18) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- evo %>% 
  select_if(is.numeric) %>% 
  colSums()

evo <- bind_rows(evo,Total)

tevo <- write.xlsx(evo,".xlsx")
saveWorkbook(tevo,file = "/17.evolucion.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

##p19	En relación al confinamiento (estudio en casa) ¿Cree usted que la educación mejorará desde que se retornó a la presencialidad?

mej <- adt %>% group_by(p19) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- mej %>% 
  select_if(is.numeric) %>% 
  colSums()

mej <- bind_rows(mej,Total)

tmej <- write.xlsx(mej,".xlsx")
saveWorkbook(tmej,file = "/18.mejor_peor.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

##p20	"¿Ha considerado en algún momento retirar a sus hijos/as de la escuela?

ret <- adt %>% 
  filter (p5=="Padre/madre de familia o cuidador/a") %>% 
  group_by(p20) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- ret %>% 
  select_if(is.numeric) %>% 
  colSums()

ret <- bind_rows(ret,Total)

tret <- write.xlsx(ret,".xlsx")
saveWorkbook(tret,file = "/19.retirar.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo

#### p22 mi vida tiene sentido

sentido <- adt %>% 
  group_by(p22) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2)) %>% 
  arrange(desc(Porcentaje))

Total <- sentido %>% 
  select_if(is.numeric) %>% 
  colSums()

sentido <- bind_rows(sentido,Total)
tsentido <- write.xlsx(sentido,".xlsx")
saveWorkbook(tsentido,file = "/20.sentido.xlsx", overwrite = T)#Ingresar ente las comillas la ruta donde va a guardar el archivo
